import torch
import torch.nn as nn

def lecun_tanh(input):
    input = torch.tanh((2*input)/3)
    return 1.7159 * input

class LeCun_tanh(nn.Module):
    def __init__(self):
        super().__init__()

    def forward(self, x):
        return lecun_tanh(x)

## torch.autograd.Function
class Elliot_auto(torch.autograd.Function):
    @staticmethod
    def forward(ctx, input):
        ctx.save_for_backward(input)
        return input / (1+torch.abs(input))

    @staticmethod
    def backward(ctx, grad_output):
        grad_input = None
        input, = ctx.saved_tensors

        if ctx.needs_input_grad[0]:
            grad_input = grad_output.clone()

            # input == 0.0
            zero_indices = input == 0.0
            # input > 0.0 or input < 0.0
            _indices = ~zero_indices

            # set grad_input for zero_indices
            grad_input[zero_indices] = 0.0
            # set grad_input for _indices
            grad_input[_indices] = grad_input[_indices] / (1+torch.abs(input[_indices]))**2
        return grad_input

## torch.nn.Module
class Elliot(nn.Module):
    def __init__(self):
        super().__init__()
    def forward(self, input):
        return Elliot_auto.apply(input)
